# One Max Search

## Programs

This project contains two main Python scripts:

1. **`One_max_search.py`**  
   - A **synthetic experiment** implementation.  
   - Focuses on the theoretical one-max search problem using interval `[p̂ - h, p̂ + h]`.  
   - Implements weight functions (linear, polynomial, Gaussian) and optimization methods (`minmax_T`, `minsum_T`, `maxcvar_T`).  
   - Produces plots of performance ratios and reports improvements of the optimized threshold `T*` over baselines.

2. **`One_max_search_real_data.py`**  
   - A **real-data experiment** implementation.  
   - Uses historical exchange rates (ECB) or Bitcoin minute data.  
   - Builds the prediction interval using 8 block maxima.  
   - Runs δT, PO1, PO2, MAX, AVG, and CVaR algorithms.  
   - Evaluates on the actual monotone sequence and reports **average ratios and profits with 95% bootstrap confidence intervals**.  
   - Outputs results in LaTeX-ready table format.

## Data Source
The script uses historical exchange rates from the European Central Bank, available from January 1999 to January 2025. The data is accessible [here](https://www.ecb.europa.eu/stats/policy_and_exchange_rates/euro_reference_exchange_rates/html/index.en.html).

## Bitcoin Data
The script can also use Bitcoin minute-level data:
- Source: [Kaggle Dataset](https://www.kaggle.com/datasets/mczielinski/bitcoin-historical-data?resource=download)  
- Coverage: Every minute from January 2012 to May 9th, 2025  
- Column of interest: closing price  
- Expected filename: `btcusd_1-min_data.csv`

## Functionality

1. **Initialization**:
   - `init_exchange_rates_ecb(currency)`: Loads ECB exchange rates for a given currency. Computes the prediction interval (`p_star` and `h`) using 8 block maxima and applies a running maximum filter to produce a monotone sequence.
   - `init_exchange_rates_btc(csv, column, window)`: Loads Bitcoin prices from CSV within a time window. Computes the same statistics as above.

2. **Weight Functions**:
   - `linear_weight(z)`: Triangular weight used for robust MAX and AVG algorithms.
   - A truncated Gaussian CDF is used internally for CVaR objectives.

3. **Optimization Functions**:
   - `minmax_T_robust`, `minsum_T_robust`: Select thresholds that minimize worst-case or average regret across the interval `[p_star-h, p_star+h]`.
   - `maxcvar_T`: Selects thresholds that maximize the CVaR objective at level `alpha`.
   - `pareto_alg`: Computes PO1 thresholds. `lambda_from_r` solves for λ given target R.

4. **Simulation**:
   - Predictions are sampled as `y = p_star + h * X` with `X ~ N(0,0.5²)` truncated to [-1,1].
   - Algorithms δT, PO1, PO2, MAX, AVG, and CVaR (for given α values) are run.
   - Evaluates **performance ratio** (`p_star / obtained_price`) and **profit** (`T` if reached, else 1).
   - Outputs averages with 95% bootstrap confidence intervals.

## Usage

- **Run with defaults in PyCharm**: simply execute the script (ECB, CHF/GBP/JPY/USD, 1000 runs, R=100).
- **Command line examples**:
  - ECB:
    ```bash
    python One_max_search_real_data.py --source ecb --csv eurofxref-hist.csv --currencies CHF GBP JPY USD --runs 10000 --R 100
    ```
  - BTC:
    ```bash
    python One_max_search_real_data.py --source btc --csv btcusd_1-min_data.csv --column Close --runs 10000 --R 100 --t0 1577833200 --t1 1735686000
    ```

The script prints LaTeX-ready table blocks with algorithm names, average ratios, and average profits.

### License
This project is under the [MIT License](https://opensource.org/licenses/MIT).
